IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='Prod_Listas_Eventos' AND xtype='U')
BEGIN
	CREATE TABLE Prod_Listas_Eventos 
	(
		Id_Lista_Evento				INT IDENTITY(0,1) NOT NULL,
		Descripcion					VARCHAR(100),
		Id_Lista_Evento_Anterior	INT,
		Activo						TINYINT,
		Flag_Web					TINYINT,
		Fecha_Desde					DATETIME,
		Fecha_Hasta					DATETIME,
		Fecha_Reserva_Hasta			DATETIME,
		Id_Sede						SMALLINT
	)
END
GO

IF EXISTS (SELECT * FROM sysobjects WHERE Name='Prod_Listas_Eventos' AND xtype='U')
BEGIN
	ALTER TABLE Prod_Listas_Eventos ADD CONSTRAINT PK_PLE_PorId PRIMARY KEY CLUSTERED (Id_Lista_Evento)	
END
GO

IF EXISTS (SELECT * FROM sysobjects WHERE Name='Prod_Listas_Eventos' AND xtype='U')
BEGIN
	ALTER TABLE Prod_Listas_Eventos ADD CONSTRAINT FK_PLE_Id_Sede FOREIGN KEY (Id_Sede)
	REFERENCES Empresas_Sedes (Id_Sede)
END
GO

IF EXISTS (SELECT * FROM sysobjects WHERE Name='Prod_Listas_Eventos' AND xtype='U')
BEGIN
	INSERT INTO Prod_Listas_Eventos 
	(Descripcion, Id_Lista_Evento_Anterior, Activo, Flag_Web, Id_Sede)
	VALUES
	( 'NO DEFINIDO', 0, 0, 0, 0)
END
GO

IF EXISTS (SELECT * FROM sysobjects WHERE Name='Prod_Listas_Eventos' AND xtype='U')
BEGIN
	ALTER TABLE Prod_Listas_Eventos ADD CONSTRAINT FK_PLE_Id_Lista_Ev_Ant FOREIGN KEY (Id_Lista_Evento)
	REFERENCES Prod_Listas_Eventos (Id_Lista_Evento)
END
GO


----------------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------------
----------------------------------------------------------------------------------------------------------------------------


IF NOT EXISTS (SELECT * FROM sysobjects WHERE Name='Prod_Listas_Eventos_Items' AND xtype='U')
BEGIN
	CREATE TABLE Prod_Listas_Eventos_Items 
	(
		Id_Lista_Evento_Item		INT IDENTITY(1,1) NOT NULL,
		Id_Lista_Evento				INT  NOT NULL,
		Id_Producto					VARCHAR(14) NOT NULL,
		Descrip_Producto			VARCHAR(150),
		Id_Sector					SMALLINT,
		Descrip_Sector				VARCHAR(50),
		Cantidad_Max				INT, /*Si la cantidad_max <> 1 tiene fila / columna)*/
		Cantidad_Vendida			INT,
		Fila						CHAR(5),
		Columna						CHAR(5),
		Estado						CHAR(1), /*L = Libre | R = Reservada | A = Abono | T = Ticket | P = Protocolo | B = Bloqueda*/
		Fecha_Modif					DATETIME,
		Fecha_Reserva_OnLine		DATETIME,
		Id_Cliente					INT,
		Razon_Social				VARCHAR(100),
		Id_Trans					INT,
		Id_Ent_Protocolo			SMALLINT,
		Descrip_Cbte				VARCHAR(100),

	)
END
GO

IF EXISTS (SELECT * FROM sysobjects WHERE Name='Prod_Listas_Eventos_Items' AND xtype='U')
BEGIN
	ALTER TABLE Prod_Listas_Eventos_Items ADD CONSTRAINT PK_PLEI_PorId PRIMARY KEY CLUSTERED (Id_Lista_Evento_Item)	
END
GO


IF EXISTS (SELECT * FROM sysobjects WHERE Name='Prod_Listas_Eventos_Items' AND xtype='U')
BEGIN
	ALTER TABLE Prod_Listas_Eventos_Items ADD CONSTRAINT FK_PLEI_Id_Producto FOREIGN KEY (Id_Producto)
	REFERENCES Productos (Id_Producto)
END
GO

IF EXISTS (SELECT * FROM sysobjects WHERE Name='Prod_Listas_Eventos_Items' AND xtype='U')
BEGIN
	ALTER TABLE Prod_Listas_Eventos_Items ADD CONSTRAINT FK_PLEI_Id_Lista_Evento FOREIGN KEY (Id_Lista_Evento)
	REFERENCES Prod_Listas_Eventos (Id_Lista_Evento)
END
GO

IF EXISTS (SELECT * FROM sysobjects WHERE Name='Prod_Listas_Eventos_Items' AND xtype='U')
BEGIN
	ALTER TABLE Prod_Listas_Eventos_Items ADD CONSTRAINT FK_PLEI_Id_Sector FOREIGN KEY (Id_Sector)
	REFERENCES Empresas_Sedes_Sectores (Id_Sector)
END
GO

IF EXISTS (SELECT * FROM sysobjects WHERE Name='Prod_Listas_Eventos_Items' AND xtype='U')
BEGIN
	ALTER TABLE Prod_Listas_Eventos_Items ADD CONSTRAINT FK_PLEI_Id_Cliente FOREIGN KEY (Id_Cliente)
	REFERENCES Clientes (Id_Cliente)
END
GO

IF EXISTS (SELECT * FROM sysobjects WHERE Name='Prod_Listas_Eventos_Items' AND xtype='U')
BEGIN
	ALTER TABLE Prod_Listas_Eventos_Items ADD CONSTRAINT FK_PLEI_Id_Trans FOREIGN KEY (Id_Trans)
	REFERENCES Cbtes (Id_Trans)
END
GO

IF EXISTS (SELECT * FROM sysobjects WHERE Name='Prod_Listas_Eventos_Items' AND xtype='U')
BEGIN
	ALTER TABLE Prod_Listas_Eventos_Items ADD CONSTRAINT FK_PLEI_Id_Ent_Protocolo FOREIGN KEY (Id_Ent_Protocolo)
	REFERENCES Tab_Ent_Protocolares  (Id_Ent_Protocolo)
END
GO